<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/ta/tawfiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/statecodes">
	<xsl:template name="Item3">
		<h3>
			Legal Action Information
		</h3>
		<xsl:call-template name="legalActionInfo" />
	</xsl:template>

	<xsl:template  name="legalActionInfo">
		
		<table role="presentation" >
			<tr>
				<b>8.</b> Is registrant directly or indirectly involved in any legal actions or proceedings
				 or aware of any potential claims against it in connection with its performance of 
				 transfer agent functions for any security?
			</tr>
			<tr>
				<td>							
					<xsl:choose>
						<xsl:when test="p:formData/p:legalAction/p:involved = 'Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:legalAction/p:involved = 'N'">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					&#160;No							
				</td>
			</tr>
			<xsl:if test="p:formData/p:legalAction/p:involved = 'Y'">
			<tr>
				<td class="label">
					<b>8(a).</b> If so, furnish complete information with respect to each:
				</td>
			</tr>				
				<xsl:for-each select="p:formData/p:legalAction/p:subjectOfProceedingsDetails">		
					<tr>
						<td class="label">
							<blockquote>
								<b>8(a)(i).</b> Individual named in the action or claim:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:entityName"/>
							</div>
						</td>
					</tr>		
					<tr>
						<td class="label">
							<blockquote>
								<b>8(a)(ii).</b> Title of the action or claim: 
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:actionTitle"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								<b>8(a)(iii).</b> Action Date: 
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:actionDate"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								<b>8(a)(iv).</b> Court or Body Name and Location:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:courtOrBodyNameAndLocation"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								<b>8(a)(v).</b> Description of the action or claim:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:actionDescription"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								<b>8(a)(vi).</b> Disposition of action or claim:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:dispositionOfProceeding"/>
							</div>
						</td>
					</tr>	
					<tr><td></td></tr>													
				</xsl:for-each>
			</xsl:if>		
  		</table>
  		
 		<table role="presentation" >
			<tr>
				<b>9.</b> Are there any unsatisfied judgments or liens against registrant arising 
				out of its performance of transfer agent functions for any security?
			</tr> 		
			<tr>
				<td>							
					<xsl:choose>
						<xsl:when test="p:formData/p:legalAction/p:unsatisfiedJudgmentsInvolved = 'Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:legalAction/p:unsatisfiedJudgmentsInvolved = 'N'">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					&#160;No							
				</td>
			</tr> 
			<xsl:if test="p:formData/p:legalAction/p:involved = 'Y'">
			<tr>
				<td class="label">
					<b>9(a).</b> If so, furnish complete information regarding each judgment or lien.
				</td>
			</tr>				
				<xsl:for-each select="p:formData/p:legalAction/p:unsatisfiedJudgementOrLiensDetails">		
					<tr>
						<td class="label">
							<blockquote>
								<b>9(a)(i).</b> Individual named in the judgment or lien:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:entityName"/>
							</div>
						</td>
					</tr>		
					<tr>
						<td class="label">
							<blockquote>
								<b>9(a)(ii).</b> Title of the judgment or lien:  
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:actionTitle"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								<b>9(a)(iii).</b> Action Date: 
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:actionDate"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								<b>9(a)(iv).</b> Court or Body Name and Location:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:courtOrBodyNameAndLocation"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								<b>9(a)(v).</b> Description of the judgment or lien:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:actionDescription"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								<b>9(a)(vi).</b> Disposition of action or claim:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:dispositionOfProceeding"/>
							</div>
						</td>
					</tr>	
					<tr><td></td></tr>													
				</xsl:for-each>
			</xsl:if>					 		
  		</table>
	</xsl:template>	
</xsl:stylesheet>